/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.mods.autocomplete.config;

import club.sk1er.mods.autocomplete.JsonHolder;
import club.sk1er.mods.autocomplete.config.FriendsConfig;
import club.sk1er.mods.autocomplete.config.GuildConfig;
import club.sk1er.mods.autocomplete.config.LocalConfig;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;

public class MasterConfig {
    private FriendsConfig friendsConfig = new FriendsConfig();
    private GuildConfig guildConfig = new GuildConfig();
    private LocalConfig localConfig = new LocalConfig();
    private boolean enabled = true;
    private HashMap<String, Integer> commands = new HashMap();

    public MasterConfig(File suggestedConfigurationFile) {
        JsonHolder data = null;
        if (suggestedConfigurationFile.exists()) {
            try {
                data = new JsonHolder(FileUtils.readFileToString((File)suggestedConfigurationFile));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (data == null) {
            data = new JsonHolder();
            int value = 7;
            this.commands.put("msg", value);
            this.commands.put("tell", value);
            this.commands.put("w", value);
            this.commands.put("t", value);
            this.commands.put("whisper", value);
            this.commands.put("party", value);
            this.commands.put("p", value);
        }
        this.load(data);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            JsonHolder data1 = new JsonHolder();
            this.save(data1);
            try {
                FileUtils.write((File)suggestedConfigurationFile, (CharSequence)data1.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }));
    }

    public HashMap<String, Integer> getCommands() {
        return this.commands;
    }

    private void load(JsonHolder data) {
        this.friendsConfig.load(data.optJsonObject("friends"));
        this.localConfig.load(data.optJsonObject("local"));
        this.guildConfig.load(data.optJsonObject("guild"));
        this.enabled = data.optBoolean("enabled", true);
        JsonHolder commands = data.optJsonObject("commands");
        for (String key : commands.getKeys()) {
            this.commands.put(key, commands.optInt(key));
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private void save(JsonHolder data) {
        JsonHolder friends = new JsonHolder();
        JsonHolder guild = new JsonHolder();
        JsonHolder local = new JsonHolder();
        this.friendsConfig.save(friends);
        this.localConfig.save(local);
        this.guildConfig.save(guild);
        data.put("friends", friends);
        data.put("guild", guild);
        data.put("local", local);
        data.put("enabled", this.enabled);
        JsonHolder commands = new JsonHolder();
        for (String s : this.commands.keySet()) {
            commands.put(s, this.commands.get(s));
        }
        data.put("commands", commands);
    }

    public GuildConfig getGuildConfig() {
        return this.guildConfig;
    }

    public LocalConfig getLocalConfig() {
        return this.localConfig;
    }

    public FriendsConfig getFriendsConfig() {
        return this.friendsConfig;
    }
}

